
 
package com.ejie.p06b.servlet.presentacion.corredores;

import java.util.ArrayList;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejie.p06b.datatype.model.P06B31T00Datatype;
import com.ejie.p06b.datatype.model.P06B81T00Datatype;
import com.ejie.p06b.datatype.model.P06B82T00Datatype;
import com.ejie.p06b.dokusi.P06bDokusiUtiles;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BPaginas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.manager.P06BCorredoresManager;
import com.ejie.p06b.p06bMediadoresSegurosEJB.P06BMediadoresSegurosEJB;
import com.ejie.p06b.p06bMediadoresSegurosEJB.P06BMediadoresSegurosEJBHome;

import com.ejie.p06b.servlet.P06BServletGenerico;
import com.ejie.p06b.tools.P06bTokenAplicacion;
import com.ejie.p06b.upload.p06bFile;
import com.ejie.p06b.upload.p06bRequest;
import com.ejie.p06b.upload.p06bSmartUpload;
import com.ejie.p06b.util.P06BParametros;

import com.ejie.t65.jaxb.beans.fsd.T65ContentType;
import com.ejie.t65.jaxb.beans.fsd.T65DocumentType;
import com.ejie.t65.jaxb.beans.fsd.T65StringListType;

import com.ejie.p06b.dokusi.P06bClienteDokusi;

import com.ejie.p06b.util.Y31JanoServiceAbstractFactory;
import com.ejie.y31.service.Y31JanoService;
import com.ejie.y31.vo.Y31AttachmentBean;

import org.w3c.dom.Document;

import java.io.BufferedInputStream;

//import org.springframework.util.FileCopyUtils;

/**
 *  Esta clase gestiona las peticiones HTTP de la aplicacin.
 */
public class P06BAdjuntarFicheroServlet extends P06BServletGenerico 
{

	//Cambia de idioma en la sesin -> Perfil
	public void ejecutar(HttpServletRequest request, HttpServletResponse response) {
	    final int TAM_BUFFER = 8192;
		try {
			if(request.getParameter("accion")==null || request.getParameter("accion").equals("") || request.getParameter("accion").equals("adjuntarDocsEnModif")){
				P06BLog.send(2,this, "Inicio P06BAdjuntarFicheroServlet-ejecutar: NOOO hay accion, se viene de la pantalla de Modificacion");
				//Se viene de la pantalla de MODIFICAR
				this.deleteTempFromSession(request,P06BConstantes.P06B_VAR_TEMP_FILTRO);//Borrar todas las variables de sesin excepto el filtro
				
				//Recuperar la lista de documentos adjuntos del expediente y meterlos en sesin
				//Poniendole la constante P06B_VAR_TEMP, se borrar de sesin al cambiar de pantalla
				request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosExped", null);
				request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosExped", P06BCorredoresManager.getInstance().selectDocsExpediente((request.getParameter("expediente")==null)?"":request.getParameter("expediente")));
				
				int nCorrelAtencionPeticionAnadirDocs = -1;
				request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosTramitaguneAP", null);
				String sObjetivo = (String)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"objetivo"+P06BConstantes.P06B_VAR_TEMP_FILTRO);
		        if (sObjetivo!= null){
		        	if (sObjetivo.equals(((Integer)P06BConstantes.P06B_BUSQCORR_TRAMITEPENDIENTE_INCORPORARMODTRAMITAGUNE).toString())){
						int nCorrelAtencionPeticionEnRevision = -1;
						nCorrelAtencionPeticionEnRevision = P06BCorredoresManager.getInstance().selectCorrelAtencionPeticionEnRevision(request.getParameter("expediente"));
						if (nCorrelAtencionPeticionEnRevision != -1){
							nCorrelAtencionPeticionAnadirDocs = nCorrelAtencionPeticionEnRevision; 							
							request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosTramitaguneAP", P06BCorredoresManager.getInstance().selectDocsTramitaguneAP(request.getParameter("expediente"),nCorrelAtencionPeticionAnadirDocs,this.getIdioma(request,response)));
						}
		        	}
		        }else{
	        		String estadoAntiguo = P06BCorredoresManager.getInstance().selectEstadoCorredor(request.getParameter("expediente"));
	        		int atencPeticIncorporada = P06BCorredoresManager.getInstance().selectAtencPeticIncorporada(request.getParameter("expediente"));
	        		if (estadoAntiguo.equals(P06BConstantes.P06B_CORREDORES_ESTADO_PDTE_ALTA)){
						request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosTramitaguneAP", P06BCorredoresManager.getInstance().selectDocsTramitaguneAP(request.getParameter("expediente"),atencPeticIncorporada,this.getIdioma(request,response)));
	        		}else if (estadoAntiguo.equals(P06BConstantes.P06B_CORREDORES_ESTADO_PDTE_BAJA)){
						request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosTramitaguneAP", P06BCorredoresManager.getInstance().selectDocsTramitaguneAP(request.getParameter("expediente"),atencPeticIncorporada,this.getIdioma(request,response)));
	        		}
		        	
		        }
		        
				request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosTramitagune", null);
				request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosTramitagune", P06BCorredoresManager.getInstance().selectDocsTramitagune(request.getParameter("expediente"),this.getIdioma(request,response)));

				//Va al JSP de adjuntar documentos o ficheros
//				forward (request, response, P06BPaginas.P06B_JSP_ADJUNTAR_FICHEROS+"?expediente="+((request.getParameter("expediente")==null)?"":request.getParameter("expediente"))+"&codMS="+((request.getParameter("codMS")==null)?"":request.getParameter("codMS")));
				forward (request, response, P06BPaginas.P06B_JSP_ADJUNTAR_FICHEROS+"?expediente="+((request.getParameter("expediente")==null)?"":request.getParameter("expediente")));
				P06BLog.send(2,this, "Fin P06BAdjuntarFicheroServlet-ejecutar: NOOO hay accion, se viene de la pantalla de Modificacion");
								
			}else if(request.getParameter("accion").equals("adjuntarDoc")){
				P06BLog.send(2,this, "Inicio P06BAdjuntarFicheroServlet-ejecutar: Accion ADJUNTAR DOCUMENTO");
				
	        	p06bSmartUpload smartUpload = new p06bSmartUpload();
				p06bRequest rq =  null;		

				smartUpload.service(request, response);

				smartUpload.upload();
				rq = smartUpload.getRequest();
				
				p06bFile file = smartUpload.getFiles().getFile(0);
				byte[] bArray = new byte[file.getSize()];
				for (int i = 0; i < file.getSize(); i++) {
					bArray[i] = file.getBinaryData(i);
				}				    
				String titulo = file.getFileName();						
				String tipoDocumento = file.getContentType();
				
				//Crear el objeto a insertar en la base de datos
				P06B31T00Datatype obj = new P06B31T00Datatype();
				obj.setNumExp((request.getParameter("Expedi")==null)?"":request.getParameter("Expedi"));
				//obj.setCorr("");//Calcularlo en el DAO, antes de hacer la insert
				//obj.setFechaDoc("");//Meter la fecha actual, en el DAO, antes de hacer la insert
				obj.setTitulo(titulo);
				obj.setTipo(tipoDocumento);
				obj.setDocumento(bArray);
				
				//Insertar el objeto en base de datos											
				Context context =new InitialContext();
				Object objRef = context.lookup(P06BParametros.get("mediadoresSeguros.ejb.jndiName"));
				P06BMediadoresSegurosEJBHome home = (P06BMediadoresSegurosEJBHome)javax.rmi.PortableRemoteObject.narrow(
		                		  objRef, P06BMediadoresSegurosEJBHome.class);
				P06BMediadoresSegurosEJB mediadoresSeguroEJB = home.create();
				P06B31T00Datatype objInsertado = mediadoresSeguroEJB.insertDocAdjunto(obj);//Devuelve el obj insertado con todos los valores
				
				//Volver a cargar en sesion la lista con el nuevo documento adjuntado
				ArrayList listaDocsAdjuntos =  new ArrayList();
	    		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosExped")!=null){
	    			listaDocsAdjuntos = (ArrayList)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosExped");
	    		}
	    		listaDocsAdjuntos.add(objInsertado);
	    		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosExped",listaDocsAdjuntos);
				    						
				//Vuelve al JSP de adjuntar documentos o ficheros
//				forward (request, response, P06BPaginas.P06B_JSP_ADJUNTAR_FICHEROS+"?expediente="+((request.getParameter("Expedi")==null)?"":request.getParameter("Expedi"))+"&codMS="+((request.getParameter("codMS")==null)?"":request.getParameter("codMS")));
				forward (request, response, P06BPaginas.P06B_JSP_ADJUNTAR_FICHEROS+"?expediente="+((request.getParameter("Expedi")==null)?"":request.getParameter("Expedi")));
				
				P06BLog.send(2,this, "Fin P06BAdjuntarFicheroServlet-ejecutar: Accion ADJUNTAR DOCUMENTO");
			}else if(request.getParameter("accion").equals("borrarDoc")){
				P06BLog.send(2,this, "Inicio P06BAdjuntarFicheroServlet-ejecutar: Accion BORRAR DOCUMENTO");
				
				if(request.getParameter("type").equals("1")){
					//Recorro la lista de documentos adjuntos y elimino aquel cuyo corr(correlativo) coincida con el id pasado
					ArrayList listaDocsAdjuntos =  new ArrayList();
		    		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosExped")!=null){
		    			listaDocsAdjuntos = (ArrayList)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosExped");
		    		}
					for(int i=0;i<listaDocsAdjuntos.size();i++){
						P06B31T00Datatype obj = (P06B31T00Datatype)listaDocsAdjuntos.get(i);
						if(obj.getCorr()!=null && obj.getCorr().equals(request.getParameter("id"))){
							//Eliminar el documento de la base de datos
							Context context =new InitialContext();
							Object objRef = context.lookup(P06BParametros.get("mediadoresSeguros.ejb.jndiName"));
							P06BMediadoresSegurosEJBHome home = (P06BMediadoresSegurosEJBHome)javax.rmi.PortableRemoteObject.narrow(
					                		  objRef, P06BMediadoresSegurosEJBHome.class);
							P06BMediadoresSegurosEJB mediadoresSeguroEJB = home.create();
							mediadoresSeguroEJB.borrarDocAdjunto(obj);											
							
							//Volver a cargar en sesin la lista eliminando el documento adjunto
							listaDocsAdjuntos.remove(i);
							request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosExped",listaDocsAdjuntos);
							break;
						}
					}					
				}else if (request.getParameter("type").equals("2")){
					ArrayList listaP06B81T00Datatype =  new ArrayList();
					if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosTramitagune")!=null){
						listaP06B81T00Datatype = (ArrayList)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosTramitagune");
					}
					for(int i=0;i<listaP06B81T00Datatype.size();i++){
						P06B81T00Datatype docTramitagune = (P06B81T00Datatype)listaP06B81T00Datatype.get(i);
						if(docTramitagune.getReferenciaEnPid().equals(request.getParameter("id"))){
							//Eliminar el documento de la base de datos
							Context context =new InitialContext();
							Object objRef = context.lookup(P06BParametros.get("mediadoresSeguros.ejb.jndiName"));
							P06BMediadoresSegurosEJBHome home = (P06BMediadoresSegurosEJBHome)javax.rmi.PortableRemoteObject.narrow(
					                		  objRef, P06BMediadoresSegurosEJBHome.class);
							P06BMediadoresSegurosEJB mediadoresSeguroEJB = home.create();
							mediadoresSeguroEJB.borrarDocTramitagune(docTramitagune);											
							
							//Volver a cargar en sesin la lista eliminando el documento adjunto
							listaP06B81T00Datatype.remove(i);
							request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosTramitagune",listaP06B81T00Datatype);
							break;
						}
					}
					
				}
				//Vuelve al JSP de adjuntar documentos o ficheros
//				forward (request, response, P06BPaginas.P06B_JSP_ADJUNTAR_FICHEROS+"?expediente="+((request.getParameter("Expedi")==null)?"":request.getParameter("Expedi"))+"&codMS="+((request.getParameter("codMS")==null)?"":request.getParameter("codMS")));
				forward (request, response, P06BPaginas.P06B_JSP_ADJUNTAR_FICHEROS+"?expediente="+((request.getParameter("Expedi")==null)?"":request.getParameter("Expedi")));
				
				P06BLog.send(2,this, "Fin P06BAdjuntarFicheroServlet-ejecutar: Accion BORRAR DOCUMENTO");
			}else if(request.getParameter("accion").equals("VerDocumento")){
				P06BLog.send(2,this, "Inicio P06BAdjuntarFicheroServlet-ejecutar: Accion VER DOCUMENTO");
				
				if(request.getParameter("type").equals("1")){
					ArrayList listaDocsAdjuntos =  new ArrayList();
					if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosExped")!=null){
						listaDocsAdjuntos = (ArrayList)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosExped");
					}
					
					//Recorro la lista de documentos adjuntos y abro aquel cuyo corr(correlativo) coincida con el id pasado
					if(listaDocsAdjuntos.size()>0){
						for(int i=0;i<listaDocsAdjuntos.size();i++){
							P06B31T00Datatype docAdjunto = (P06B31T00Datatype)listaDocsAdjuntos.get(i);
							if(docAdjunto.getCorr()!=null && docAdjunto.getCorr().equals(request.getParameter("id"))){
								//Abrir el fichero adjunto
								ServletOutputStream outStream = null;
								response.reset();
								outStream = response.getOutputStream();
								response.setHeader("Content-disposition", "attachment; filename=" + docAdjunto.getTitulo());
								response.setContentType(docAdjunto.getTipo());
								outStream.write(docAdjunto.getDocumento());
								
								break;
							}
						}
					}					
				}else if (request.getParameter("type").equals("2")){
					ArrayList listaP06B81T00Datatype =  new ArrayList();
					if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosTramitagune")!=null){
						listaP06B81T00Datatype = (ArrayList)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosTramitagune");
					}
					//Recuperamos documento desde DOKUSI a travs de PIF
	                String strToken = "";
                    strToken = P06bTokenAplicacion.prepareXMLSessionTokenAplic();	                
                    String strAuditUser = P06bDokusiUtiles.obtenerAuditUserDefecto(null);
                    T65ContentType content = T65ContentType.Factory.newInstance();
                    content.setPifId(P06BParametros.get("pifID"));
                    T65StringListType keysList = T65StringListType.Factory.newInstance();
                    keysList.addElement("object_name");
                    T65DocumentType type = P06bClienteDokusi.fncRetrieveDocument(strToken, strAuditUser, request.getParameter("id"), content, keysList);
                    String pifID = type.getContent().getPifId();
                    Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();
                    Document tokenAplic = P06bTokenAplicacion.prepareTokenAplic();
                    Y31AttachmentBean resul = service.info(tokenAplic, type.getContent().getPifId());
                    BufferedInputStream inputStream = new BufferedInputStream(service.get(tokenAplic, pifID));
                    response.setContentType(resul.getContentType());
					String nombreCompletoFichero = "No localizado";
					for(int i=0;i<listaP06B81T00Datatype.size();i++){
						P06B81T00Datatype docTramitagune = (P06B81T00Datatype)listaP06B81T00Datatype.get(i);
						if(docTramitagune.getReferenciaEnPid().equals(request.getParameter("id"))){
							nombreCompletoFichero = docTramitagune.getNombreEnPid();
							if (docTramitagune.getExtensionEnPid()!=null){
								nombreCompletoFichero += "." + docTramitagune.getExtensionEnPid(); 
							}
							break;
						}
					}
                    response.addHeader("Content-Disposition", "attachment; filename=\"" + nombreCompletoFichero + "\"");							
                    // Escribe fichero
                    ServletOutputStream ostream = response.getOutputStream();
                    int readBytes = 0;
                    byte buf[] = new byte[TAM_BUFFER];
                    while ((readBytes = inputStream.read(buf)) != -1) {
                         ostream.write(buf, 0, readBytes);
                    }
                    ostream.flush();
                    ostream.close();
                    inputStream.close();
//                    FileCopyUtils.copy(fileByteArray, response.getOutputStream());                    
				}else if (request.getParameter("type").equals("3")){
					ArrayList listaP06B82T00Datatype =  new ArrayList();
					if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosTramitaguneAP")!=null){
						listaP06B82T00Datatype = (ArrayList)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"docsAdjuntosTramitaguneAP");
					}
					//Recuperamos documento desde DOKUSI a travs de PIF
	                String strToken = "";
                    strToken = P06bTokenAplicacion.prepareXMLSessionTokenAplic();	                
                    String strAuditUser = P06bDokusiUtiles.obtenerAuditUserDefecto(null);
                    T65ContentType content = T65ContentType.Factory.newInstance();
                    content.setPifId(P06BParametros.get("pifID"));
                    T65StringListType keysList = T65StringListType.Factory.newInstance();
                    keysList.addElement("object_name");
                    T65DocumentType type = P06bClienteDokusi.fncRetrieveDocument(strToken, strAuditUser, request.getParameter("id"), content, keysList);
                    String pifID = type.getContent().getPifId();
                    Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();
                    Document tokenAplic = P06bTokenAplicacion.prepareTokenAplic();
                    Y31AttachmentBean resul = service.info(tokenAplic, type.getContent().getPifId());
                    BufferedInputStream inputStream = new BufferedInputStream(service.get(tokenAplic, pifID));
                    response.setContentType(resul.getContentType());
					String nombreCompletoFichero = "No localizado";
					for(int i=0;i<listaP06B82T00Datatype.size();i++){
						P06B82T00Datatype docTramitagune = (P06B82T00Datatype)listaP06B82T00Datatype.get(i);
						if(docTramitagune.getReferenciaEnPid().equals(request.getParameter("id"))){
							nombreCompletoFichero = docTramitagune.getNombreEnPid();
							if (docTramitagune.getExtensionEnPid()!=null){
								nombreCompletoFichero += "." + docTramitagune.getExtensionEnPid(); 
							}
							break;
						}
					}
                    response.addHeader("Content-Disposition", "attachment; filename=\"" + nombreCompletoFichero + "\"");							
                    // Escribe fichero
                    ServletOutputStream ostream = response.getOutputStream();
                    int readBytes = 0;
                    byte buf[] = new byte[TAM_BUFFER];
                    while ((readBytes = inputStream.read(buf)) != -1) {
                         ostream.write(buf, 0, readBytes);
                    }
                    ostream.flush();
                    ostream.close();
                    inputStream.close();
//                    FileCopyUtils.copy(fileByteArray, response.getOutputStream());                    
				}
				
				P06BLog.send(2,this, "Fin P06BAdjuntarFicheroServlet-ejecutar: Accion VER DOCUMENTO");
			}				
			
//		}finally{
//			
		}catch (Exception e){
	      	manejarErrores (request, response, e);
	        return;
	    }
	}
		
}